package gov.va.vinci.dart.db.mock;

import gov.va.vinci.dart.biz.Comment;
import gov.va.vinci.dart.biz.NestableComment;
import gov.va.vinci.dart.db.CommentDAO;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.ArrayList;
import java.util.List;

public class NestableCommentDAOMock {

	private int requestId;
	
	public NestableCommentDAOMock(int requestId) {
		this.requestId = requestId;
	}
	
	public List<NestableComment> build() {
		List<NestableComment> result = new ArrayList<NestableComment>();
		
		CommentDAO commentDAO = DartObjectFactory.getInstance().getCommentDAO();
		
		for (Comment comment : commentDAO.listAll()) {

			if (comment.getRequest().getId() == requestId) {
				NestableComment nc = new NestableComment();
				nc.setCreatedOn(new java.sql.Timestamp(System.currentTimeMillis()));
				nc.setRequestId(requestId);
				nc.setId(comment.getId());
				nc.setVersion(comment.getVersion());
				nc.setDescription(comment.getDescription());
				nc.setText(comment.getText());
				
				// the parent id and child/Parent relation text is going to get squirrelly
				//  then 'Parent' else 'Child' end as rel
				if (comment.getPreviousComment() != null) {
					nc.setParentId(comment.getPreviousComment().getId());
					nc.setRelation("Child");
				}
				else {
					nc.setRelation("Parent");
					nc.setParentId(nc.getId());
				}

				result.add(nc);
			}
		}
		
		return result;
	}
}
